clc
clear
close all
set(0,'defaultTextInterpreter','latex'); %trying to set the default
% set(0,'defaultAxesFontSize',20);
% set(0,'defaultAxesFontName','TimesNewRoman');

%% Control panel
Omega_rpm = 70e3; 
h_min = 15e-6;
T_tiltd_vec = 5:2.5:25; % deg
T_tiltd = T_tiltd_vec(1); %deg
sh_vec = (4:2:30)*1e-6;
dt=2.5e-8;                %Time Step (s)
% sh=30e-6;
sh = sh_vec(1);
plot_current_case_only = 0;

%% Model
%Input data
%Physical parameters
Rg=287.053; %Costante dell'aria (J/kg/K)
mu=1.81e-5; %viscosita` dinamica dell'aria a 20C (Pa s)
pa=101325;
Temp=293;                  %Temperature (K)
rho=pa/(Rg*Temp);
cG=60000/rho;
%Geometrical parameters
R1 =16e-3 ; % inner radius (m)
R2 =33e-3 ;  % outer radius (m)
Rm=(R1+R2)/2;
T1d=0; %deg
T2d=30; %deg
T1=T1d*pi/180;
T2=T2d*pi/180;
T_tilt = T_tiltd*pi/180;
% h_max=40e-6;
% h_vec = (5:25)*1e-6;
% h_min=h_vec(1);

% Lambda=100;
% omega0=Lambda*pa*(h_min/Rm)^2/(6*mu)*1e-3;
% Omega_rpm=(omega0:omega0*0.5:7*omega0)*1e3;
% Omega_rpm = 5e3;
omega=Omega_rpm*2*pi/60;
no_pad=12;

%Definizione numero elementini nelle due direzioni
M=30; %direzione radiale
N=30;%direzione circonferenziale
deltar=(R2-R1)/(M-1);
deltat=(T2-T1)/(N-1);
nR =linspace(R1,R2,M); %Vettore dei raggi
nT =linspace(T1,T2-deltat,N);%Vettore degli angoli
%caso di periodicit
% nT=[nT(end), nT, nT(1)];
[T,R] = meshgrid(nT,nR) ; %crea le coordinate di tutti i punti %nR lo replica su ogni riga %nT su ogni colonna
% Convert grid to cartesian coordintes
X = R.*cos(T);
Y = R.*sin(T);
%Definisco valore raggio
Rv=sqrt(X.^2+Y.^2);

H0 = ones(M,N)*h_min;
x_tilt = T_tiltd/T2d;
tilt_start = round(N*x_tilt);
for ind_gap = 1:tilt_start
    ht=h_min+sh*(tilt_start-ind_gap+1)/(tilt_start);
    H0(:,ind_gap)=ht;
end

figure
surf(X*1e3,Y*1e3,H0*1e6)
xlabel('X (mm)'),ylabel('Y (mm)'),zlabel('Air Gap Height ($\mu m$)')
pause(0.1)


%Variable Initialization
%COndizioni Periodicit
% pold=ones(N+2,M)*pa; %N+2 per periodicit circolare lungo theta
% pnew=ones(N+2,M)*pa;
%COndizioni di Dirichelet p=Pa sul bordo esterno

F_mat = zeros(length(sh_vec),length(T_tiltd_vec));
W = zeros(size(T_tiltd_vec));
Qin = W;
Qout = W;
for sh_i = 1:length(sh_vec)
    sh = sh_vec(sh_i);

for x_i = 1:length(T_tiltd_vec)
    Pold=ones(M,N)*pa; %MODIFICATO
    Pnew=Pold;

    % h_min = h_vec(h_i);
    H0(:,:) = h_min;
    T_tiltd = T_tiltd_vec(x_i);
    x_tilt = T_tiltd/T2d;
    tilt_start = round(N*x_tilt);
    for ind_gap = 1:tilt_start
        ht=h_min+sh*(tilt_start-ind_gap+1)/(tilt_start);
        H0(:,ind_gap)=ht;
    end

    fprintf('a = %d deg ; sh = %d um\n',T_tiltd_vec(x_i),sh*1e6)

    tic
    err_P=10;
    err_F=10;
    err_G=10;

    %portate uscita nodo
    GN=zeros(M,N); %N and M are for BC
    GS=zeros(M,N);
    gO=zeros(M,N);
    gE=zeros(M,N);
    F0=0;
    F1=0;

    iter=0;
    contatore=0;
    toll=1e-5;
    while abs(err_P)>toll || abs(err_G)>toll || abs(err_F)>toll
        iter=iter+1;
        contatore=contatore+1;
        F0=F1;
        Pold=Pnew;


        ii=2:M-1;   jj=2:N-1; %Nodi interni
        %Calcolo portata uscita radiale
        GN(ii,jj)=-(Pold(ii-1,jj).*H0(ii-1,jj).^3.*Rv(ii-1,jj)+Pold(ii,jj).*H0(ii,jj).^3.*Rv(ii,jj))./(24*mu*Rg*Temp*deltar).*(Pold(ii,jj)-Pold(ii-1,jj));
        GS(ii,jj)=-(Pold(ii,jj).*H0(ii,jj).^3.*Rv(ii,jj)+Pold(ii+1,jj).*H0(ii+1,jj).^3.*Rv(ii+1,jj))./(24*mu*Rg*Temp*deltar).*(Pold(ii+1,jj)-Pold(ii,jj));
        %Calcolo portata uscita circonferenziale
        gOp(ii,jj)=-(Pold(ii,jj-1).*H0(ii,jj-1).^3+Pold(ii,jj).*H0(ii,jj).^3)./(12*mu*Rg*Temp*(Rv(ii,jj-1)+Rv(ii,jj)).*deltat).*(Pold(ii,jj)-Pold(ii,jj-1));
        gOc(ii,jj)=omega*(Pold(ii,jj-1).*H0(ii,jj-1).*Rv(ii,jj-1)+Pold(ii,jj).*H0(ii,jj).*Rv(ii,jj))./(4*Rg*Temp);
        gO(ii,jj)=gOp(ii,jj)+gOc(ii,jj);
        gEp(ii,jj)=-(Pold(ii,jj).*H0(ii,jj).^3+Pold(ii,jj+1).*H0(ii,jj+1).^3)./(12*mu*Rg*Temp*(Rv(ii,jj)+Rv(ii,jj+1)).*deltat).*(Pold(ii,jj+1)-Pold(ii,jj));
        gEc(ii,jj)=omega*(Pold(ii,jj).*H0(ii,jj).*Rv(ii,jj)+Pold(ii,jj+1).*H0(ii,jj+1).*Rv(ii,jj+1))./(4*Rg*Temp);
        gE(ii,jj)=gEp(ii,jj)+gEc(ii,jj);
        %Calcolo pressione meato da equazione di continuit
        Pnew(ii,jj)=Pold(ii,jj)+((GN(ii,jj)-GS(ii,jj))*deltat+(gO(ii,jj)-gE(ii,jj))*deltar).*(dt*Rg*Temp)./(H0(ii,jj).*Rv(ii,jj)*deltar*deltat);
        %Calcolo errore Pressione
        err_P=abs(max((Pnew(:)-Pold(:))./Pold(:)));
        % Err_P_i(iter)=err_P;

        %Diverge?
        if any(isnan(Pnew(:))) || any(isinf(Pnew(:)))
            fprintf('Iterations diverge\n');
            return;
        end
        %Calcolo della capacit di carico
        F1=sum((Pnew-pa)*deltar*deltat.*Rv,'all');

        %Calcolo della portata in uscita O-N-E-S
        Gin=sum(GN(ii,jj)*deltat+gO(ii,jj)*deltar,'all');
        Gout=sum(GS(ii,jj)*deltat+gE(ii,jj)*deltar,'all');
        % %Calcolo errore
        err_F=(F1-F0)/F1;
        err_G_num=sum(Gin-Gout,'all');
        err_G=err_G_num/Gout;

        %   if contatore==2000
        %      figure
        %    surf(X*1e3,Y*1e3,Pnew), hold on
        %    xlabel('X (mm)'),ylabel('Y (mm)'),zlabel('Pressure (Pa)')
        %    grid on,set(gca,'FontSize', 24)
        %    contatore=0;
        %   end

    end
    toc
    W(x_i)=F1*no_pad;
    Qin(x_i)=Gin*cG;
    Qout(x_i)=Gout*cG;
    
    close all
    figure
    surf(X*1e3,Y*1e3,Pnew)
    xlabel('X (mm)'),ylabel('Y (mm)'),zlabel('Pressure (Pa)')
    grid on
    pause(0.5)
end
F_mat(sh_i,:) = W;

figure
plot(T_tiltd_vec,W,'b'),hold on
plot(T_tiltd_vec,W,'ro'),hold on
xlabel('Tapered sector $a$ [$deg$]'),ylabel('Load Capacity $W$ (N)')
title(['Tapered Bearing; $s_h=$ ' num2str(sh*1e6) ' $\mu m$ ; $\omega=$'...
    num2str(Omega_rpm)])
% legend('Numerical','Experimental')
grid on

end

%% Curve Caratteristiche
% Capacit di carico
[SH,TILT] = meshgrid(sh_vec*1e6,T_tiltd_vec);
[row,col] = find(F_mat==max(F_mat,[],'all'));
figure
hold on
surf(SH,TILT,F_mat')
plot3(SH(col,row),TILT(col,row),F_mat(row,col),'.k','MarkerSize',20)
hold off
xlabel('$s_h$ [$\mu m$]')
ylabel('Tapered sector $a$ [$deg$]')
zlabel('Load capacity $W$ [$W$]')
title(['Tapered Bearing load capacity at $\omega=$' ...
    num2str(Omega_rpm*1e-3) ' krpm'])
colorbar
grid on

%% Salvataggio
F_mat_tapered = F_mat;
sh_vec_tapered = sh_vec;
save Tapered_opt F_mat_tapered sh_vec_tapered T_tiltd_vec

% load Tapered_opt
% sh_vec = sh_vec_tapered;
% F_mat = F_mat_tapered;
% 
% 
% fid = fopen('sim_data_tapered.txt','wt');
% fprintf(fid,'dt: %+.2e\n',dt);
% fprintf(fid,'M: %d\nN: %d\n',M,N);
% fclose(fid);
